#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 1000005
#define INF 2e18

typedef long long ll;

typedef struct {
    ll x, h, id;
} Mast;

Mast masts[MAXN];
ll ans[MAXN];

int cmp(const void *a, const void *b) {
    Mast *ma = (Mast*)a;
    Mast *mb = (Mast*)b;
    if (ma->x < mb->x) return -1;
    if (ma->x > mb->x) return 1;
    return 0;
}

double cable_height(ll x1, ll y1, ll x2, ll y2, ll x) {
    if (x < x1 || x > x2) return -1;
    ll xp = (y1 - y2 + x1 + x2) / 2;
    if (x <= xp) {
        return y1 - (x - x1);
    } else {
        return y2 - (x2 - x);
    }
}

double min_dist_to_cable(ll x0, ll y0, ll x1, ll y1, ll x2, ll y2) {
    ll xp = (y1 - y2 + x1 + x2) / 2;
    ll best_x = -1;
    
    if (y1 >= y0) {
        ll x_max = x1 + (y1 - y0);
        if (x_max >= x1 && x_max <= xp) {
            best_x = x_max;
        } else if (y1 - (xp - x1) >= y0) {
            best_x = xp;
        } else if (y1 >= y0) {
            best_x = x1;
        }
    }
    
    if (y2 >= y0) {
        ll x_min = x2 - (y2 - y0);
        if (x_min >= xp && x_min <= x2) {
            if (best_x == -1 || llabs(x_min - x0) < llabs(best_x - x0)) {
                best_x = x_min;
            }
        } else if (y2 - (x2 - xp) >= y0) {
            if (best_x == -1 || llabs(xp - x0) < llabs(best_x - x0)) {
                best_x = xp;
            }
        } else if (y2 >= y0) {
            if (best_x == -1 || llabs(x2 - x0) < llabs(best_x - x0)) {
                best_x = x2;
            }
        }
    }
    
    if (best_x == -1) return INF;
    
    double cable_y = cable_height(x1, y1, x2, y2, best_x);
    double dx = best_x - x0;
    double dy = cable_y - y0;
    return sqrt(dx*dx + dy*dy);
}

ll stack[MAXN];
ll top;

int main() {
    ll n;
    scanf("%lld", &n);
    for (ll i = 0; i < n; i++) {
        scanf("%lld", &masts[i].x);
        masts[i].id = i;
    }
    for (ll i = 0; i < n; i++) {
        scanf("%lld", &masts[i].h);
    }
    
    qsort(masts, n, sizeof(Mast), cmp);
    
    for (ll i = 0; i < n; i++) {
        ans[i] = -1;
    }
    
    top = -1;
    for (ll i = 0; i < n; i++) {
        while (top >= 0 && masts[stack[top]].h < masts[i].h) {
            top--;
        }
        if (top >= 0) {
            ll left = stack[top];
            double dist = min_dist_to_cable(masts[i].x, masts[i].h, 
                                             masts[left].x, masts[left].h, 
                                             masts[i].x, masts[i].h);
            if (dist < INF/2) {
                ll idx = masts[i].id;
                ll rd = (ll)round(dist);
                if (ans[idx] == -1 || rd < ans[idx]) {
                    ans[idx] = rd;
                }
            }
        }
        stack[++top] = i;
    }
    
    top = -1;
    for (ll i = n-1; i >= 0; i--) {
        while (top >= 0 && masts[stack[top]].h < masts[i].h) {
            top--;
        }
        if (top >= 0) {
            ll right = stack[top];
            double dist = min_dist_to_cable(masts[i].x, masts[i].h, 
                                             masts[i].x, masts[i].h, 
                                             masts[right].x, masts[right].h);
            if (dist < INF/2) {
                ll idx = masts[i].id;
                ll rd = (ll)round(dist);
                if (ans[idx] == -1 || rd < ans[idx]) {
                    ans[idx] = rd;
                }
            }
        }
        stack[++top] = i;
    }
    
    for (ll i = 0; i < n; i++) {
        if (i > 0) {
            double dist = min_dist_to_cable(masts[i].x, masts[i].h, 
                                             masts[i-1].x, masts[i-1].h, 
                                             masts[i].x, masts[i].h);
            if (dist < INF/2) {
                ll idx = masts[i].id;
                ll rd = (ll)round(dist);
                if (ans[idx] == -1 || rd < ans[idx]) {
                    ans[idx] = rd;
                }
            }
        }
        if (i < n-1) {
            double dist = min_dist_to_cable(masts[i].x, masts[i].h, 
                                             masts[i].x, masts[i].h, 
                                             masts[i+1].x, masts[i+1].h);
            if (dist < INF/2) {
                ll idx = masts[i].id;
                ll rd = (ll)round(dist);
                if (ans[idx] == -1 || rd < ans[idx]) {
                    ans[idx] = rd;
                }
            }
        }
    }
    
    for (ll i = 0; i < n; i++) {
        printf("%lld\n", ans[i]);
    }
    
    return 0;
}